/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.postgresql;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jtbcore.db.model.ColumnModel;
import jtbcore.db.model.DatabaseModel;
import jtbcore.db.model.TableModel;
import jtbcore.db.postgresql.PostgresqlConnection;
import jtbcore.db.sql.SqlColumn;
import jtbcore.db.sql.SqlDatabase;
import jtbcore.db.sql.SqlTable;
import jtbcore.model.BaseStringMap;

public class PostgresqlTableModelGenerator {
    protected DatabaseModel model;
    protected List<String> updateQueries;

    public PostgresqlTableModelGenerator() {
    }

    public PostgresqlTableModelGenerator(DatabaseModel model) {
        this.setModel(model);
    }

    public DatabaseModel getModel() {
        return this.model;
    }

    public void setModel(DatabaseModel model) {
        this.model = model;
    }

    public String generateCreateTable(String tableName) {
        TableModel tm = this.getModel().getTable(tableName);
        List<ColumnModel> cols = tm.getColumns();
        StringBuilder b = new StringBuilder();
        b.append("CREATE TABLE ");
        if (tm.getSchemaName() != null) {
            b.append("\"" + tm.getSchemaName() + "\"").append(".");
        }
        b.append("\"" + tm.getName() + "\"");
        b.append(" (\n");
        int cnt = 0;
        for (ColumnModel cm : cols) {
            String type = this.dbtype(cm.getType());
            if (cm.isAutoIncrement()) {
                b.append("    ").append("\"" + cm.getName() + "\"").append(" serial ");
            } else {
                b.append("    ").append("\"" + cm.getName() + "\"").append(" ").append(type);
            }
            if (cm.isPrimaryKey()) {
                b.append(" PRIMARY KEY ");
            }
            if (cm.isUnique()) {
                b.append(" UNIQUE ");
            }
            if (cnt < cols.size() - 1) {
                b.append(",");
            }
            b.append("\n");
            ++cnt;
        }
        b.append(")\n");
        return b.toString();
    }

    public String generateAddColumn(String tableName, ColumnModel cm) {
        String sql = "ALTER TABLE \"" + tableName + "\" ADD COLUMN \"" + cm.getName() + "\" " + this.dbtype(cm.getType());
        return sql;
    }

    public List<TableModel> updateSchema(PostgresqlConnection con) throws SQLException, IOException {
        TableModel tm;
        ArrayList<TableModel> updatedTables = new ArrayList<TableModel>();
        this.updateQueries = new ArrayList<String>();
        Map<String, TableModel> tablesModel = this.model.getTables();
        SqlDatabase sqlDb = this.sqlDatabaseModelOnly(con);
        boolean schemaQuerySet = false;
        for (String tblInModel : tablesModel.keySet()) {
            if (sqlDb.getTable(tblInModel) != null || !(tm = tablesModel.get(tblInModel)).isAutogenerated()) continue;
            if (!schemaQuerySet) {
                this.updateQueries.add("CREATE SCHEMA IF NOT EXISTS eodump");
                schemaQuerySet = true;
            }
            String sqlCreate = this.generateCreateTable(tblInModel);
            this.updateQueries.add(sqlCreate);
            if (updatedTables.contains(tm)) continue;
            updatedTables.add(tm);
        }
        for (SqlTable st : sqlDb.getTables()) {
            tm = tablesModel.get(st.getName());
            if (tm == null) continue;
            for (ColumnModel cm : tm.getColumns()) {
                if (st.getColumnByName(cm.getName()) != null) continue;
                String sqlAdd = this.generateAddColumn(tm.getName(), cm);
                System.out.println(sqlAdd);
                this.updateQueries.add(sqlAdd);
                if (updatedTables.contains(tm)) continue;
                updatedTables.add(tm);
            }
        }
        for (String q : this.updateQueries) {
            System.out.println("Queries: " + q);
            con.query(q, new Object[0]);
        }
        return updatedTables;
    }

    public SqlTable buildSqlTable(PostgresqlConnection con, String tblSchema, String tblName) throws SQLException {
        String databaseName = con.getDatabaseName();
        String sql = "select * from information_schema.\"tables\"  where table_catalog = ? and table_schema = ? and table_name = ? \tand table_type='BASE TABLE' ";
        List tbl = con.queryList(sql, con.getDatabaseName(), tblSchema, tblName);
        if (tbl.size() == 0) {
            return null;
        }
        List recPks = con.queryList("SELECT ccu.COLUMN_NAME FROM INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE ccu JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS ts on (ccu.CONSTRAINT_NAME = ts.CONSTRAINT_NAME) WHERE     ccu.TABLE_CATALOG = ?     AND ccu.TABLE_NAME=?     AND ts.CONSTRAINT_TYPE='PRIMARY KEY'", databaseName, tblName);
        ArrayList<String> pks = new ArrayList<String>();
        for (BaseStringMap bsm : recPks) {
            pks.add(bsm.getProperty("COLUMN_NAME"));
        }
        List cols = con.queryList("select * from information_schema.\"columns\" where table_catalog   = ? \t\tand table_schema = ? \t\tand table_name   = ? order by ordinal_position ", databaseName, tblSchema, tblName);
        SqlTable table = new SqlTable(((BaseStringMap)tbl.get(0)).getProperty("table_name"));
        table.setStartTopVal('\"', '\"');
        table.setSchemaName(tblSchema);
        for (BaseStringMap col : cols) {
            boolean isAutoincrement = false;
            String colDefault = col.getProperty("column_default");
            if (colDefault != null && colDefault.contains("nextval(")) {
                isAutoincrement = true;
            }
            SqlColumn scol = new SqlColumn();
            scol.name = col.getProperty("column_name");
            scol.sqlDatatype = col.getProperty("udt_name");
            if ("varchar".equals(scol.sqlDatatype)) {
                scol.sqlDatatype = scol.sqlDatatype + "(" + col.getProperty("character_maximum_length") + ")";
                Integer maxlen = col.getPropertyInt("character_maximum_length");
                if (maxlen != null) {
                    scol.maxLen = maxlen;
                }
            }
            scol.primaryKey = pks.contains(scol.name);
            scol.autoincrement = isAutoincrement;
            scol.internalType = this.internalDataType(col.getProperty("udt_name"));
            table.setColumn(scol);
        }
        return table;
    }

    public SqlDatabase sqlDatabaseModelOnly(PostgresqlConnection con) throws IOException, SQLException {
        SqlDatabase db = new SqlDatabase();
        Map<String, TableModel> tms = this.model.getTables();
        for (String k : tms.keySet()) {
            TableModel tm = tms.get(k);
            SqlTable st = this.buildSqlTable(con, tm.getSchemaName(), tm.getName());
            if (st == null) continue;
            db.addTable(st);
        }
        return db;
    }

    public SqlDatabase postgresToSqlDatabase(PostgresqlConnection con) throws IOException, SQLException {
        SqlDatabase db = new SqlDatabase();
        String databaseName = con.getDatabaseName();
        String sql = "select * from information_schema.\"tables\" where table_catalog = ? \tand table_type='BASE TABLE' ";
        List recTables = con.queryList(sql, databaseName);
        for (BaseStringMap recTbl : recTables) {
            String tblName = recTbl.getProperty("table_name");
            String tblSchema = recTbl.getProperty("table_schema");
            if (tblSchema.startsWith("pg_") || tblSchema.equalsIgnoreCase("information_schema")) continue;
            SqlTable table = this.buildSqlTable(con, tblSchema, tblName);
            db.addTable(table);
        }
        return db;
    }

    public SqlColumn.DataType internalDataType(String dataType) {
        if ((dataType = dataType.toLowerCase()).startsWith("varchar") || dataType.startsWith("char") || dataType.indexOf("text") != -1 || dataType.indexOf("enum") != -1) {
            return SqlColumn.DataType.TEXT;
        }
        if (dataType.indexOf("binary") != -1 || dataType.indexOf("blob") != -1) {
            return SqlColumn.DataType.TEXT;
        }
        if (dataType.indexOf("int") != -1 || dataType.indexOf("bool") != -1) {
            return SqlColumn.DataType.NUMERIC;
        }
        if (dataType.indexOf("float") != -1 || dataType.indexOf("double") != -1 || dataType.indexOf("decimal") != -1) {
            return SqlColumn.DataType.REAL;
        }
        if (dataType.indexOf("date") != -1 || dataType.indexOf("timestamp") != -1) {
            return SqlColumn.DataType.DATE;
        }
        return SqlColumn.DataType.TEXT;
    }

    public String dbtype(String modelType) {
        if ((modelType = modelType.toLowerCase()).startsWith("varchar")) {
            return modelType;
        }
        if ("text".equals(modelType)) {
            return "text";
        }
        if ("longtext".equals(modelType)) {
            return "longtext";
        }
        if ("bool".equals(modelType) || "boolean".equals(modelType)) {
            return "smallint";
        }
        if ("int".equals(modelType) || "int32".equals(modelType)) {
            return "int";
        }
        if ("int64".equals(modelType) || "bigint".equals(modelType) || "long".equals(modelType)) {
            return "bigint";
        }
        if ("double".equals(modelType)) {
            return "double precision";
        }
        if ("float".equals(modelType)) {
            return "float";
        }
        if ("blob".equals(modelType)) {
            return "BLOB";
        }
        if ("datetime".equals(modelType)) {
            return "timestamp";
        }
        if ("date".equals(modelType)) {
            return "date";
        }
        return "text";
    }

    public static void main(String[] args) {
    }
}

